# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ....core.serialization import FieldMetadata
from .download_options import DownloadOptions


class UploadFileOptions(UniversalBaseModel):
    """
    Additional configurations for your file.
    """

    delete_at: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="deleteAt")] = pydantic.Field(
        default=None
    )
    """
    Set a deletion date for your file in ISO 8601 format. After this date, the file will be automatically deleted from our storage.<br>
    
    If this field is not provided, the file will not be deleted. You can still schedule deletion or delete the file manually in the Storage page in the dashboard.
    """

    download: typing.Optional[DownloadOptions] = pydantic.Field(default=None)
    """
    Configure download settings for your uploaded file.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
