# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_url_options import CreateUrlOptions
from ...types.shortened_url import ShortenedUrl
from ...types.shortened_url_with_click_data import ShortenedUrlWithClickData
from .raw_client import AsyncRawUrlClient, RawUrlClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UrlClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUrlClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUrlClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUrlClient
        """
        return self._raw_client

    def create(
        self,
        *,
        url: str,
        options: typing.Optional[CreateUrlOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ShortenedUrl:
        """
        Create a shortened URL that redirects visitors to the provided destination URL.

        Parameters
        ----------
        url : str
            Destination URL for the shortened link that visitors will be redirected to when clicked.

        options : typing.Optional[CreateUrlOptions]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ShortenedUrl
            Successfully created.

        Examples
        --------
        from rcs import CreateUrlOptions, Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.tools.url.create(
            url="https://www.pinnacle.sh/",
            options=CreateUrlOptions(
                expires_at="2025-06-23T16:18:25.000Z",
            ),
        )
        """
        _response = self._raw_client.create(url=url, options=options, request_options=request_options)
        return _response.data

    def get(
        self, link_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ShortenedUrlWithClickData:
        """
        Retrieve configuration and details for your shortened URL using its unique identifier.

        Parameters
        ----------
        link_id : str
            Unique identifier from your shortened URL. For example, for `https://pncl.to/ePzVxILF`, the `linkId` is `ePzVxILF`. <br>

            See the response of [Create Shortened URL](./create-url) for more information.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ShortenedUrlWithClickData
            Returns your URL details.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.tools.url.get(
            link_id="ePzVxILF",
        )
        """
        _response = self._raw_client.get(link_id, request_options=request_options)
        return _response.data

    def update(
        self,
        link_id: str,
        *,
        url: typing.Optional[str] = OMIT,
        options: typing.Optional[CreateUrlOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ShortenedUrl:
        """
        Update the destination or expiration date of an existing shortened URL. Expiring links cannot be updated into a permalink.

        Parameters
        ----------
        link_id : str
            Unique identifier from your shortened URL. For example, for `https://pncl.to/ePzVxILF`, the `linkId` is `ePzVxILF`. <br>

            See the response of [Create Shortened URL](./create-url) for more information.

        url : typing.Optional[str]
            New destination URL where your visitors will be redirected.

        options : typing.Optional[CreateUrlOptions]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ShortenedUrl
            Returns the updated shortened URL and its configuration.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.tools.url.update(
            link_id="ePzVxILF",
            url="https://www.pinnacle.sh/",
        )
        """
        _response = self._raw_client.update(link_id, url=url, options=options, request_options=request_options)
        return _response.data


class AsyncUrlClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUrlClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUrlClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUrlClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        url: str,
        options: typing.Optional[CreateUrlOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ShortenedUrl:
        """
        Create a shortened URL that redirects visitors to the provided destination URL.

        Parameters
        ----------
        url : str
            Destination URL for the shortened link that visitors will be redirected to when clicked.

        options : typing.Optional[CreateUrlOptions]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ShortenedUrl
            Successfully created.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle, CreateUrlOptions

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.url.create(
                url="https://www.pinnacle.sh/",
                options=CreateUrlOptions(
                    expires_at="2025-06-23T16:18:25.000Z",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(url=url, options=options, request_options=request_options)
        return _response.data

    async def get(
        self, link_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ShortenedUrlWithClickData:
        """
        Retrieve configuration and details for your shortened URL using its unique identifier.

        Parameters
        ----------
        link_id : str
            Unique identifier from your shortened URL. For example, for `https://pncl.to/ePzVxILF`, the `linkId` is `ePzVxILF`. <br>

            See the response of [Create Shortened URL](./create-url) for more information.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ShortenedUrlWithClickData
            Returns your URL details.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.url.get(
                link_id="ePzVxILF",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(link_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        link_id: str,
        *,
        url: typing.Optional[str] = OMIT,
        options: typing.Optional[CreateUrlOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ShortenedUrl:
        """
        Update the destination or expiration date of an existing shortened URL. Expiring links cannot be updated into a permalink.

        Parameters
        ----------
        link_id : str
            Unique identifier from your shortened URL. For example, for `https://pncl.to/ePzVxILF`, the `linkId` is `ePzVxILF`. <br>

            See the response of [Create Shortened URL](./create-url) for more information.

        url : typing.Optional[str]
            New destination URL where your visitors will be redirected.

        options : typing.Optional[CreateUrlOptions]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ShortenedUrl
            Returns the updated shortened URL and its configuration.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.url.update(
                link_id="ePzVxILF",
                url="https://www.pinnacle.sh/",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(link_id, url=url, options=options, request_options=request_options)
        return _response.data
