# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .advanced_phone_information_carrier import AdvancedPhoneInformationCarrier
from .advanced_phone_information_contact import AdvancedPhoneInformationContact
from .advanced_phone_information_location import AdvancedPhoneInformationLocation
from .advanced_phone_information_type import AdvancedPhoneInformationType
from .number_format import NumberFormat


class AdvancedPhoneInformation(UniversalBaseModel):
    """
    Detailed phone number analysis including validation status, classification with fraud risk,
    precise geographic data, carrier intelligence, and enhanced contact information.
    Provides comprehensive insights for risk assessment, compliance, and advanced usage scenarios.
    """

    is_valid: typing_extensions.Annotated[bool, FieldMetadata(alias="isValid")] = pydantic.Field()
    """
    Indicates whether the phone number is valid and capable of receiving communications.
    """

    type: AdvancedPhoneInformationType = pydantic.Field()
    """
    Detailed classification including fraud risk and security recommendations.
    """

    formats: NumberFormat = pydantic.Field()
    """
    Different standardized ways the phone number can be formatted for display or dialing.
    """

    location: AdvancedPhoneInformationLocation = pydantic.Field()
    """
    Comprehensive geographic and administrative location data with precise coordinates
    and timezone information for accurate localization.
    """

    carrier: AdvancedPhoneInformationCarrier = pydantic.Field()
    """
    Detailed carrier information.
    """

    contact: typing.Optional[AdvancedPhoneInformationContact] = pydantic.Field(default=None)
    """
    Enhanced contact information associated with the phone number.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
