# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class AdvancedPhoneInformationCarrier(UniversalBaseModel):
    """
    Detailed carrier information.
    """

    name: str = pydantic.Field()
    """
    Carrier or service provider name as registered with telecom authorities.
    """

    normalized_carrier: typing_extensions.Annotated[str, FieldMetadata(alias="normalizedCarrier")] = pydantic.Field()
    """
    Standardized carrier name used across data sources.
    """

    mcc: str = pydantic.Field()
    """
    Mobile Country Code - 3-digit identifier assigned by ITU-T for the country.
    Used in GSM, UMTS, and LTE networks for international roaming and identification.
    """

    mnc: str = pydantic.Field()
    """
    Mobile Network Code - 2 or 3-digit identifier for the specific carrier within the country.
    Combined with MCC provides unique global identification of the mobile network.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
