# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .enhanced_contact import EnhancedContact


class AdvancedPhoneInformationContact(UniversalBaseModel):
    """
    Enhanced contact information associated with the phone number.
    """

    first_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="firstName")] = pydantic.Field(
        default=None
    )
    """
    Given name of the primary contact.
    """

    last_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="lastName")] = pydantic.Field(
        default=None
    )
    """
    Family name of the primary contact.
    """

    email_address: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="emailAddress")] = (
        pydantic.Field(default=None)
    )
    """
    Primary email associated with the number’s registration.
    """

    street: typing.Optional[str] = pydantic.Field(default=None)
    """
    Street address including number and street name.
    """

    unit: typing.Optional[str] = pydantic.Field(default=None)
    """
    Secondary address info like suite or apartment number.
    """

    place: typing.Optional[str] = pydantic.Field(default=None)
    """
    Combined city, state, and postal info in a human-readable format.
    """

    zip: typing.Optional[str] = pydantic.Field(default=None)
    """
    Postal or ZIP code of the contact’s address.
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    Full state or province name of the contact’s address.
    """

    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    Full country name of the contact’s registered address.
    """

    profiles: typing.Optional[EnhancedContact] = pydantic.Field(default=None)
    """
    Collection of online profiles and social media accounts associated with the contact. <br>
    
    These are potential candidates and may be inaccurate. Always double check.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
