# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .advanced_phone_information_location_coordinates import AdvancedPhoneInformationLocationCoordinates
from .advanced_phone_information_location_country import AdvancedPhoneInformationLocationCountry


class AdvancedPhoneInformationLocation(UniversalBaseModel):
    """
    Comprehensive geographic and administrative location data with precise coordinates
    and timezone information for accurate localization.
    """

    country: AdvancedPhoneInformationLocationCountry = pydantic.Field()
    """
    Complete country identification and metadata.
    """

    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    Primary city or municipality associated with the phone number.
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    State, province, or primary administrative division code.
    Uses standard 2-letter abbreviations where applicable.
    """

    zip: typing.Optional[str] = pydantic.Field(default=None)
    """
    Postal or ZIP code for the phone number's registered location.
    """

    metro_code: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="metroCode")] = pydantic.Field(
        default=None
    )
    """
    Primary Metropolitan Statistical Area (PMSA) code for US numbers.
    Used for demographic and market analysis purposes.
    """

    county: typing.Optional[str] = pydantic.Field(default=None)
    """
    County or secondary administrative division name.
    """

    coordinates: AdvancedPhoneInformationLocationCoordinates = pydantic.Field()
    """
    Coordinates provide the precise latitude and longitude values for the phone number’s registered location.
    """

    time_zone: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="timeZone")] = pydantic.Field(
        default=None
    )
    """
    IANA timezone identifier for the number’s location.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
