# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .advanced_phone_information_type_recommendation import AdvancedPhoneInformationTypeRecommendation
from .detailed_phone_number_enum import DetailedPhoneNumberEnum


class AdvancedPhoneInformationType(UniversalBaseModel):
    """
    Detailed classification including fraud risk and security recommendations.
    """

    value: DetailedPhoneNumberEnum = pydantic.Field()
    """
    Technical classification derived from carrier intelligence systems.
    """

    description: str = pydantic.Field()
    """
    Explanation of the phone number type and service
    """

    details: str = pydantic.Field()
    """
    Additional technical details about the service type, billing model,
    and typical usage patterns for this number classification.
    """

    recommendation: AdvancedPhoneInformationTypeRecommendation = pydantic.Field()
    """
    Security recommendation based on fraud risk analysis:
    - `ALLOW`: Low risk, safe for normal use.
    - `BLOCK`: High risk, block or require additional verification.
    - `FLAG`: Medium risk, recommend further scrutiny or monitoring.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
