# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .webhook_event_enum import WebhookEventEnum


class AttachWebhookByIdParams(UniversalBaseModel):
    """
    Attach a webhook you’ve already created in your account to this phone number.
    """

    webhook_id: typing_extensions.Annotated[str, FieldMetadata(alias="webhookId")] = pydantic.Field()
    """
    The unique ID of the webhook you want to attach. This identifier is a string that always begins with the prefix `wh_`, for example: `wh_1234567890`.
    """

    event: typing.Optional[WebhookEventEnum] = pydantic.Field(default=None)
    """
    Select the event type that will trigger this webhook. <br>
    
    Set to null if you want to listen to all event types for this phone number. <br>
    
    Defaults to null.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
