# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AttachWebhookResponseWebhook(UniversalBaseModel):
    """
    Detailed information about the attached webhook.
    """

    id: str = pydantic.Field()
    """
    Unique identifier of the webhook within the account. This identifier is a string that always begins with the prefix `wh_`, for example: `wh_1234567890`.
    """

    name: str = pydantic.Field()
    """
    Name of the webhook.
    """

    url: str = pydantic.Field()
    """
    The HTTPS endpoint URL where webhook events will be sent as HTTP POST requests.
    """

    secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    Secret key used to verify the authenticity of incoming webhook requests. <br>
    
    This secret key will be stored in the `PINNACLE-SIGNING-SECRET` header.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
