# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .autofill_dlc_response_keywords import AutofillDlcResponseKeywords
from .autofill_dlc_response_links import AutofillDlcResponseLinks
from .autofill_dlc_response_options import AutofillDlcResponseOptions
from .autofill_dlc_response_use_case import AutofillDlcResponseUseCase


class AutofillDlcCampaignResponse(UniversalBaseModel):
    auto_renew: typing_extensions.Annotated[bool, FieldMetadata(alias="autoRenew")] = pydantic.Field()
    """
    Whether the campaign renews automatically.
    """

    brand: typing.Optional[str] = pydantic.Field(default=None)
    """
    Brand id. This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.
    """

    campaign_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="campaignId")] = pydantic.Field(
        default=None
    )
    """
    Unique identifier for the campaign. This identifier is a string that always begins with the prefix `dlc_`, for example: `dlc_1234567890`.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the campaign.
    """

    keywords: typing.Optional[AutofillDlcResponseKeywords] = pydantic.Field(default=None)
    """
    Keyword response configuration.
    """

    links: typing.Optional[AutofillDlcResponseLinks] = pydantic.Field(default=None)
    """
    Legal documentation links.
    """

    message_flow: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="messageFlow")] = (
        pydantic.Field(default=None)
    )
    """
    Describe the flow of how users will opt in to this campaign.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Display name of the campaign.
    """

    options: typing.Optional[AutofillDlcResponseOptions] = pydantic.Field(default=None)
    """
    Campaign configuration options.
    """

    sample_messages: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="sampleMessages")
    ] = pydantic.Field(default=None)
    """
    Example messages for the campaign.
    """

    use_case: typing_extensions.Annotated[
        typing.Optional[AutofillDlcResponseUseCase], FieldMetadata(alias="useCase")
    ] = pydantic.Field(default=None)
    """
    Use case for the campaign.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
