# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class AutofillDlcResponseOptions(UniversalBaseModel):
    """
    Campaign configuration options.
    """

    affiliate_marketing: typing_extensions.Annotated[bool, FieldMetadata(alias="affiliateMarketing")] = pydantic.Field()
    """
    Whether the campaign uses affiliate marketing.
    """

    age_gated: typing_extensions.Annotated[bool, FieldMetadata(alias="ageGated")] = pydantic.Field()
    """
    Whether the campaign is age-gated.
    """

    direct_lending: typing_extensions.Annotated[bool, FieldMetadata(alias="directLending")] = pydantic.Field()
    """
    Whether the campaign involves direct lending.
    """

    embedded_link: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="embeddedLink")] = (
        pydantic.Field(default=None)
    )
    """
    Link embedded in campaign message.
    """

    embedded_phone: typing_extensions.Annotated[bool, FieldMetadata(alias="embeddedPhone")] = pydantic.Field()
    """
    Whether messages include phone numbers.
    """

    number_pooling: typing_extensions.Annotated[bool, FieldMetadata(alias="numberPooling")] = pydantic.Field()
    """
    Whether the campaign uses number pooling.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
