# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .basic_phone_information_contact import BasicPhoneInformationContact
from .basic_phone_information_location import BasicPhoneInformationLocation
from .number_format import NumberFormat
from .phone_number_enum import PhoneNumberEnum


class BasicPhoneInformation(UniversalBaseModel):
    """
    Key details about a phone number, including its validity, type, location, carrier, and contact information.
    Provides the essential data required for verification, display, and basic analysis.
    """

    is_valid: typing_extensions.Annotated[bool, FieldMetadata(alias="isValid")] = pydantic.Field()
    """
    Indicates whether the phone number is valid and capable of receiving communications.
    """

    type: PhoneNumberEnum = pydantic.Field()
    """
    Classification of the phone number.
    """

    formats: NumberFormat = pydantic.Field()
    """
    Different standardized ways the phone number can be formatted for display.
    """

    location: BasicPhoneInformationLocation = pydantic.Field()
    """
    Geographic and political details where the phone number is registered.
    """

    carrier: str = pydantic.Field()
    """
    The telecommunications carrier or service provider for the number.
    """

    contact: BasicPhoneInformationContact = pydantic.Field()
    """
    Contact information linked to the phone number registration, if available.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
