# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .brand_status_enum import BrandStatusEnum


class BrandStatus(UniversalBaseModel):
    """
    Response for get brand status.
    """

    errors: typing.List[str] = pydantic.Field()
    """
    List of errors that occurred.
    """

    id: str = pydantic.Field()
    """
    The unique identifier of the brand. This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.
    """

    status: BrandStatusEnum = pydantic.Field()
    """
    Current review status of the brand. <br>
    
    `INCOMPLETE`: Has not been submitted. Use the [submit endpoint](../brands/submit). <br>
    `PENDING`: Currently being reviewed. <br>
    `VERIFIED`: Verified and good to go. <br>
    `UNVERIFIED`: No longer verified due to an update in the brand details. Requires vetting to be reverified. <br>
    `VETTED`: Brand has been vetted by an external provider and has received vetting scores. <br>
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
