# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .button_clicked_data_button_raw import ButtonClickedDataButtonRaw
from .button_clicked_data_button_type import ButtonClickedDataButtonType


class ButtonClickedDataButton(UniversalBaseModel):
    """
    Information about the button that was clicked.
    """

    type: typing.Optional[ButtonClickedDataButtonType] = pydantic.Field(default=None)
    """
    Type of button clicked. 
    - `CARD` for card buttons, 
    - `QUICK_REPLY` for quick replies. 
    - `null` if we cannot determine the button type. This is a rare edge case and is mainly here for backward compatibility.
    """

    raw: ButtonClickedDataButtonRaw = pydantic.Field()
    """
    Raw button data. Contains the entire button that was clicked by the user. In rare cases where we cannot determine the exact button, this will return only the button title.
    """

    payload: typing.Optional[str] = pydantic.Field(default=None)
    """
    Extracted payload from the button's `payload` field, if provided. Provides quick access to any payload that was attached to the button.
    """

    metadata: typing.Optional[str] = pydantic.Field(default=None)
    """
    Additional metadata attached to the button's `metadata` field, if provided.
    """

    clicks: int = pydantic.Field()
    """
    Number of times the button has been clicked.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
