# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .attach_webhook_response_webhook import AttachWebhookResponseWebhook
from .webhook_event_enum import WebhookEventEnum


class ConfiguredWebhook(UniversalBaseModel):
    """
    Confirmation that a webhook has been successfully attached to the specified phone number.
    Includes detailed webhook information, the subscribed event type, and the associated phone number.
    """

    webhook: AttachWebhookResponseWebhook = pydantic.Field()
    """
    Detailed information about the attached webhook.
    """

    event: WebhookEventEnum = pydantic.Field()
    """
    Specific event type configured for this webhook attachment.
    """

    phone_number: typing_extensions.Annotated[str, FieldMetadata(alias="phoneNumber")] = pydantic.Field()
    """
    Phone number in E.164 format that is linked to the webhook.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
