# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class Contact(UniversalBaseModel):
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Additional information about the contact.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Contact's email address, if available.
    """

    id: str = pydantic.Field()
    """
    Unique ID of the contact. This identifier is a string that always begins with the prefix `co_`, for example: `co_1234567890`.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Full name of the contact, if available.
    """

    phone_number: typing_extensions.Annotated[str, FieldMetadata(alias="phoneNumber")] = pydantic.Field()
    """
    Contact's phone number in E.164 format.
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of tags associated with the contact.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
