# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .campaign_query import CampaignQuery
from .conversation_contact import ConversationContact
from .conversation_sender import ConversationSender


class Conversation(UniversalBaseModel):
    """
    Conversation that was found.
    """

    brand_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="brandId")] = pydantic.Field(
        default=None
    )
    """
    The unique identifier of the brand associated with this conversation. This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.
    """

    campaign: typing.Optional[CampaignQuery] = pydantic.Field(default=None)
    """
    Campaign information if this conversation is part of a marketing campaign. This is an object that contains the campaign ID and type.
    """

    contact: ConversationContact = pydantic.Field()
    """
    Contact information for the recipient in a conversation.
    """

    created_at: typing_extensions.Annotated[str, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    ISO 8601 timestamp when the conversation was created.
    """

    id: str = pydantic.Field()
    """
    Unique identifier for the conversation. This identifier is a string that always begins with the prefix `conv_`, for example: `conv_1234567890`.
    """

    notes: str = pydantic.Field()
    """
    Free-form notes or comments about the conversation.
    """

    sender: typing.Optional[ConversationSender] = pydantic.Field(default=None)
    """
    The sender of messages in this conversation. Can be:
    - A phone number with its capabilities and metadata
    - An RCS agent with ID and name
    - `null` if no sender is associated
    """

    updated_at: typing_extensions.Annotated[str, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    ISO 8601 timestamp when the conversation was last updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
