# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ConversationContact(UniversalBaseModel):
    """
    Contact information for the recipient in a conversation.
    """

    id: str = pydantic.Field()
    """
    Unique ID of the contact. This identifier is a string that always begins with the prefix `co_`, for example: `co_1234567890`.
    """

    phone_number: typing_extensions.Annotated[str, FieldMetadata(alias="phoneNumber")] = pydantic.Field()
    """
    The contact's phone number in E.164 format.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
