# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .webhook_event_enum import WebhookEventEnum


class CreateAndAttachWebhookByUrlParams(UniversalBaseModel):
    """
    Create a new webhook and immediately attach it to your phone number.
    """

    name: str = pydantic.Field()
    """
    Name of your new webhook.
    """

    url: str = pydantic.Field()
    """
    HTTPS endpoint where your webhook events will be sent as HTTP POST requests. <br>
    
    Ensure this URL is publicly accessible and ready to handle incoming webhook calls.
    """

    event: typing.Optional[WebhookEventEnum] = pydantic.Field(default=None)
    """
    Select the event type that will trigger this webhook. <br>
    
    Set to null if you want to listen to all event types for this phone number. <br>
    
    Defaults to null.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
