# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .get_dlc_campaign_status_response_updates import GetDlcCampaignStatusResponseUpdates
from .profile_status_enum import ProfileStatusEnum


class DlcCampaignStatus(UniversalBaseModel):
    """
    Response for get DLC campaign status.
    """

    error: str = pydantic.Field()
    """
    Summary of errors related to the verification process. <br>
    
    These errors may request additional information or point out erroneous and/or missing fields.
    """

    id: str = pydantic.Field()
    """
    The unique identifier of the 10DLC campaign. This identifier is a string that always begins with the prefix `dlc_`, for example: `dlc_1234567890`.
    """

    status: ProfileStatusEnum = pydantic.Field()
    """
    Current review status of the DLC campaign. <br>
    
    `INCOMPLETE`: Not submitted.<br>
    `IN REVIEW`: Being reviewed by carriers.<br>
    `VERIFIED`: Approved and ready to send messages.<br>
    `FAILED`: Issues and errors related to the campaign's details. See [error](dlc-campaign#response.body.error) for these potential issues.
    """

    updates: GetDlcCampaignStatusResponseUpdates = pydantic.Field()
    """
    Status of local long code numbers that are being attached to this campaign. <br>
    
    Note that phone numbers can only be attached to `VERIFIED` campaigns via the [attach campaign endpoint](../phone-numbers/attach-campaign).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
