# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .dlc_with_extended_brand_and_status_keywords import DlcWithExtendedBrandAndStatusKeywords
from .dlc_with_extended_brand_and_status_links import DlcWithExtendedBrandAndStatusLinks
from .dlc_with_extended_brand_and_status_options import DlcWithExtendedBrandAndStatusOptions
from .dlc_with_extended_brand_and_status_use_case import DlcWithExtendedBrandAndStatusUseCase
from .extended_brand import ExtendedBrand
from .profile_status_enum import ProfileStatusEnum


class DlcCampaignWithExtendedBrandAndStatus(UniversalBaseModel):
    """
    Dlc campaign schema that includes extended brand and status.
    """

    auto_renew: typing_extensions.Annotated[bool, FieldMetadata(alias="autoRenew")] = pydantic.Field()
    """
    Whether the campaign renews automatically.
    """

    brand: ExtendedBrand = pydantic.Field()
    """
    Brand associated with this campaign.
    """

    campaign_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="campaignId")] = pydantic.Field(
        default=None
    )
    """
    Unique identifier for the campaign. This identifier is a string that always begins with the prefix `dlc_`, for example: `dlc_1234567890`.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the campaign.
    """

    keywords: DlcWithExtendedBrandAndStatusKeywords = pydantic.Field()
    """
    Keyword response configuration.
    """

    links: typing.Optional[DlcWithExtendedBrandAndStatusLinks] = pydantic.Field(default=None)
    """
    Legal documentation links.
    """

    message_flow: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="messageFlow")] = (
        pydantic.Field(default=None)
    )
    """
    Describe the flow of how users will opt in to this campaign.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Display name of the campaign.
    """

    options: DlcWithExtendedBrandAndStatusOptions = pydantic.Field()
    """
    Campaign configuration options.
    """

    sample_messages: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="sampleMessages")
    ] = pydantic.Field(default=None)
    """
    Example messages for the campaign.
    """

    status: ProfileStatusEnum = pydantic.Field()
    """
    Current review status of the campaign. <br>
    
    `INCOMPLETE`: Not submitted. <br>
    
    `IN REVIEW`: Being reviewed by carriers. <br>
    
    `VERIFIED`: Approved and ready to send messages. <br>
    
    `FAILED`: Issues and errors related to the campaign's details.
    """

    use_case: typing_extensions.Annotated[
        typing.Optional[DlcWithExtendedBrandAndStatusUseCase], FieldMetadata(alias="useCase")
    ] = pydantic.Field(default=None)
    """
    Use case for the campaign.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
