# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class EnhancedContactItem(UniversalBaseModel):
    description: str = pydantic.Field()
    """
    Professional or personal description of the contact.
    May include job title, company affiliation, or biographical information.
    """

    email: str = pydantic.Field()
    """
    Primary email address associated with this contact profile.
    """

    links: typing.List[str] = pydantic.Field()
    """
    Additional web links associated with this contact profile.
    May include personal websites, social media profiles, or professional portfolios.
    """

    linkedin: typing.Optional[str] = pydantic.Field(default=None)
    """
    LinkedIn profile URL if available and publicly accessible.
    Null if no LinkedIn profile is found or accessible.
    """

    name: str = pydantic.Field()
    """
    Full name of the contact person associated with this profile.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
