# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from .brand_status_enum import BrandStatusEnum
from .optional_brand_info import OptionalBrandInfo


class ExtendedBrand(OptionalBrandInfo):
    created_at: typing_extensions.Annotated[str, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    ISO 8601 formatted timestamp of when this brand was added to our system.
    """

    id: str = pydantic.Field()
    """
    The brand's ID. This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.
    """

    is_archived: typing_extensions.Annotated[bool, FieldMetadata(alias="isArchived")] = pydantic.Field()
    """
    Indicates if this brand is archived.
    """

    status: BrandStatusEnum = pydantic.Field()
    """
    Current review status of the brand. <br>
    
    `INCOMPLETE`: Not submitted. <br>
    
    `IN REVIEW`: Being reviewed by carriers. <br>
    
    `VERIFIED`: Approved and ready to send messages. <br>
    
    `FAILED`: Issues and errors related to the campaign's details. <br>
    
    `VETTED`: Has undergone additional vetting by a third party service post the brand being verified. Your brand will be assigned a trust score, with higher trust scores having higher message volumes. <br>
    
    `UNVERIFIED`: Brand details have been updated, and the brand will need to undergo re-verification.
    """

    updated_at: typing_extensions.Annotated[str, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    ISO 8601 formatted timestamp of when this brand was last updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
