# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from .extended_brand import ExtendedBrand
from .vetting_feedback import VettingFeedback
from .vetting_history import VettingHistory


class ExtendedBrandWithVetting(ExtendedBrand):
    last_tcr_vetting_date: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="lastTcrVettingDate")
    ] = pydantic.Field(default=None)
    """
    ISO 8601 formatted timestamp of the last TCR vetting.
    """

    tcr_feedback: typing_extensions.Annotated[
        typing.Optional[typing.List[VettingFeedback]], FieldMetadata(alias="tcrFeedback")
    ] = pydantic.Field(default=None)
    """
    Feedback from The Campaign Registry if TCR vetting was performed.
    """

    vetting_history: typing_extensions.Annotated[typing.List[VettingHistory], FieldMetadata(alias="vettingHistory")] = (
        pydantic.Field()
    )
    """
    History of all external vetting attempts for this brand.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
