# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .extended_brand import ExtendedBrand
from .profile_status_enum import ProfileStatusEnum
from .rcs_campaign_schema_extra_agent import RcsCampaignSchemaExtraAgent
from .rcs_campaign_schema_extra_links import RcsCampaignSchemaExtraLinks
from .rcs_campaign_schema_extra_opt_in import RcsCampaignSchemaExtraOptIn
from .rcs_campaign_schema_extra_opt_out import RcsCampaignSchemaExtraOptOut
from .rcs_campaign_schema_extra_use_case import RcsCampaignSchemaExtraUseCase


class ExtendedRcsCampaign(UniversalBaseModel):
    agent: RcsCampaignSchemaExtraAgent = pydantic.Field()
    """
    Agent configured to the campaign.
    """

    agent_id: typing_extensions.Annotated[str, FieldMetadata(alias="agentId")] = pydantic.Field()
    """
    Agent's unique identifier.
    """

    brand: ExtendedBrand = pydantic.Field()
    """
    Brand associated with this campaign.
    """

    brand_verification_url: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="brandVerificationUrl")
    ] = pydantic.Field(default=None)
    """
    Link to document verifying the brand's name. This may be the certificate of incorporation, business license, or other relevant document. You can typically find this on the Secretary of State website.
    """

    brand_attestation: typing_extensions.Annotated[bool, FieldMetadata(alias="brandAttestation")] = pydantic.Field()
    """
    Indicates whether the brand has provided an attestation.
    """

    campaign_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="campaignId")] = pydantic.Field(
        default=None
    )
    """
    Unique identifier for the campaign. This identifier is a string that always begins with the prefix `rcs_`, for example: `rcs_1234567890`.
    """

    expected_agent_responses: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="expectedAgentResponses")
    ] = pydantic.Field(default=None)
    """
    List of what the agent might say to users.
    """

    links: typing.Optional[RcsCampaignSchemaExtraLinks] = pydantic.Field(default=None)
    """
    Legal documentation links.
    """

    status: ProfileStatusEnum
    opt_in: typing_extensions.Annotated[typing.Optional[RcsCampaignSchemaExtraOptIn], FieldMetadata(alias="optIn")] = (
        pydantic.Field(default=None)
    )
    """
    Opt-in configuration.
    """

    opt_out: typing_extensions.Annotated[
        typing.Optional[RcsCampaignSchemaExtraOptOut], FieldMetadata(alias="optOut")
    ] = pydantic.Field(default=None)
    """
    Opt-out configuration.
    """

    use_case: typing_extensions.Annotated[
        typing.Optional[RcsCampaignSchemaExtraUseCase], FieldMetadata(alias="useCase")
    ] = pydantic.Field(default=None)
    """
    Use case classification for the campaign.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
