# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .dlc_assignment_status_enum import DlcAssignmentStatusEnum


class GetDlcCampaignStatusResponseUpdates(UniversalBaseModel):
    """
    Status of local long code numbers that are being attached to this campaign. <br>

    Note that phone numbers can only be attached to `VERIFIED` campaigns via the [attach campaign endpoint](../phone-numbers/attach-campaign).
    """

    number: str = pydantic.Field()
    """
    Number associated with the campaign in E.164 format.
    """

    status: DlcAssignmentStatusEnum = pydantic.Field()
    """
    Current assignment status of the phone number to this campaign. <br>
    
    `ASSIGNED`: Number assigned and ready to send messages.<br>
    `PENDING_ASSIGNMENT`: In the process of being assigned. This should take no more than 10 minutes.<br>
    `PENDING_UNASSIGNMENT`: In the process of being unassigned. This should take no more that 5 minutes.<br>
    `FAILED_ASSIGNMENT`: Failed to assign the number. Use the phone number status endpoint to see errors.<br>
    `FAILED_UNASSIGNMENT`: Failed to unassign the number. Use the phone number status endpoint to see errors.
    """

    errors: typing.List[str] = pydantic.Field()
    """
    List of errors that occurred.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
