# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .toll_free_status_enum import TollFreeStatusEnum


class GetTollFreeCampaignStatusResponseUpdates(UniversalBaseModel):
    """
    Status of phone numbers that are being attached to this campaign. <br>

    Note that phone numbers can only be attached to `VERIFIED` campaigns via the [attach campaign endpoint](../phone-numbers/attach-campaign).
    """

    errors: typing.List[str] = pydantic.Field()
    """
    List of errors that occurred.
    """

    number: str = pydantic.Field()
    """
    Number associated with the campaign in E.164 format.
    """

    status: TollFreeStatusEnum = pydantic.Field()
    """
    Current assignment status of the toll free number to this campaign. <br>
    
    `IN_PROGRESS`: Being reviewed.<br>
    `WAITING_FOR_PROVIDER`: Being reviewed by our toll-free vendor.<br>
    `WAITING_FOR_TELECO:` Final review by carriers before number is live.<br>
    `VERIFIED`: Verified and ready to send messages.<br>
    `REJECTED`: Issues were found related to your campaign. See the [errors field](toll-free-campaign#response.body.error).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
