# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class LinkClickEvent(UniversalBaseModel):
    accept_language: typing.Optional[str] = pydantic.Field(default=None)
    """
    Accept-Language header value.
    """

    accuracy_radius_km: typing.Optional[int] = pydantic.Field(default=None)
    """
    Accuracy radius for geographic coordinates in kilometers.
    """

    asn: typing.Optional[int] = pydantic.Field(default=None)
    """
    Autonomous System Number.
    """

    blocked_reason: typing.Optional[str] = pydantic.Field(default=None)
    """
    Reason why the request was blocked (if applicable).
    """

    ch_ua_brand: typing.Optional[str] = pydantic.Field(default=None)
    """
    User-Agent Client Hint brand.
    """

    ch_ua_mobile: typing.Optional[str] = pydantic.Field(default=None)
    """
    User-Agent Client Hint mobile indicator.
    """

    ch_ua_platform: typing.Optional[str] = pydantic.Field(default=None)
    """
    User-Agent Client Hint platform.
    """

    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    City name.
    """

    color_depth: typing.Optional[int] = pydantic.Field(default=None)
    """
    Color depth in bits.
    """

    connection_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Type of internet connection.
    """

    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    Country code (ISO 3166-1 alpha-2).
    """

    created_at: str = pydantic.Field()
    """
    Timestamp when the click occurred in ISO 8601 format.
    """

    error_details: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Error details if the request failed.
    """

    fbclid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Facebook Click Identifier.
    """

    final_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Final resolved URL after redirects.
    """

    fingerprint_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique fingerprint identifier for the client.
    """

    gclid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Google Click Identifier.
    """

    ip_address: typing.Optional[str] = pydantic.Field(default=None)
    """
    IP address of the visitor (may be anonymized).
    """

    ip_chain: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Chain of IP addresses for proxied requests.
    """

    is_bot: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the request was identified as coming from a bot.
    """

    latency_ms: typing.Optional[int] = pydantic.Field(default=None)
    """
    Request latency in milliseconds.
    """

    latitude: typing.Optional[float] = pydantic.Field(default=None)
    """
    Geographic latitude.
    """

    longitude: typing.Optional[float] = pydantic.Field(default=None)
    """
    Geographic longitude.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Additional metadata as JSON object.
    """

    method: typing.Optional[str] = pydantic.Field(default=None)
    """
    HTTP method used.
    """

    metro_code: typing.Optional[int] = pydantic.Field(default=None)
    """
    Metro area code.
    """

    network_downlink: typing.Optional[float] = pydantic.Field(default=None)
    """
    Network downlink speed estimate in Mbps.
    """

    network_rtt: typing.Optional[int] = pydantic.Field(default=None)
    """
    Network round-trip time in milliseconds.
    """

    performance_ttfb_ms: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time to first byte in milliseconds,.
    """

    postal_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    Postal/ZIP code.
    """

    redirect_hops: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of redirect hops to reach final destination.
    """

    referrer: typing.Optional[str] = pydantic.Field(default=None)
    """
    The referring URL.
    """

    referrer_domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    Domain of the referring URL.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    Region or state.
    """

    resolved_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    Timestamp when the redirect was resolved in ISO 8601 format.
    """

    screen_res: typing.Optional[str] = pydantic.Field(default=None)
    """
    Screen resolution.
    """

    status_code: typing.Optional[int] = pydantic.Field(default=None)
    """
    HTTP status code of the response.
    """

    timezone_offset_min: typing.Optional[int] = pydantic.Field(default=None)
    """
    Timezone offset in minutes from UTC.
    """

    tor_exit_node: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the request came from a Tor exit node.
    """

    ua_browser: typing.Optional[str] = pydantic.Field(default=None)
    """
    Browser name.
    """

    ua_device: typing.Optional[str] = pydantic.Field(default=None)
    """
    Device type.
    """

    ua_os: typing.Optional[str] = pydantic.Field(default=None)
    """
    Operating system.
    """

    ua_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    Browser version.
    """

    user_agent: typing.Optional[str] = pydantic.Field(default=None)
    """
    User agent string from the browser.
    """

    utm_campaign: typing.Optional[str] = pydantic.Field(default=None)
    """
    UTM campaign parameter.
    """

    utm_content: typing.Optional[str] = pydantic.Field(default=None)
    """
    UTM content parameter.
    """

    utm_medium: typing.Optional[str] = pydantic.Field(default=None)
    """
    UTM medium parameter.
    """

    utm_source: typing.Optional[str] = pydantic.Field(default=None)
    """
    UTM source parameter.
    """

    utm_term: typing.Optional[str] = pydantic.Field(default=None)
    """
    UTM term.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
