# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class LocationShareActionData(UniversalBaseModel):
    """
    Location data shared by the user.
    """

    address: str = pydantic.Field()
    """
    Address corresponding to the shared location.
    """

    latitude: float = pydantic.Field()
    """
    Latitude of the shared location.
    """

    longitude: float = pydantic.Field()
    """
    Longitude of the shared location.
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    Text message sent with the location.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
