# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .message_content import MessageContent
from .message_method_enum import MessageMethodEnum
from .message_protocol_enum import MessageProtocolEnum
from .message_status_enum import MessageStatusEnum


class Message(UniversalBaseModel):
    content: MessageContent
    cost: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total cost charged for sending the message. <br>
    
    Null means the message incurred no cost or has not been charged yet.
    """

    delivered_at: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="deliveredAt")] = (
        pydantic.Field(default=None)
    )
    """
    Timestamp indicating when the message was successfully delivered to the recipient. <br>
    
    Null indicates the message has not yet been delivered.
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Detailed explanation of any errors that occurred while delivering the message. <br>
    
    Null indicates no errors.
    """

    id: str = pydantic.Field()
    """
    Unique identifier of the message. This identifier is a string that always begins with the prefix `msg_`, for example: `msg_1234567890`.
    """

    method: MessageMethodEnum
    num_segments: typing_extensions.Annotated[int, FieldMetadata(alias="numSegments")] = pydantic.Field()
    """
    Number of segments the message was split into for delivery.
    """

    receiver: str = pydantic.Field()
    """
    Phone number that received the message in E.164 format.
    """

    sender: str = pydantic.Field()
    """
    Phone number or agent that sent the message.
    """

    sent_at: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="sentAt")] = pydantic.Field(
        default=None
    )
    """
    Timestamp indicating when the message was submitted for delivery. <br>
    
    Null indicates the message is still in the queue.
    """

    status: MessageStatusEnum
    type: MessageProtocolEnum

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
