# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .message_event_content import MessageEventContent
from .message_event_conversation import MessageEventConversation
from .message_event_direction import MessageEventDirection
from .message_status_enum import MessageStatusEnum
from .webhook_event_enum import WebhookEventEnum


class MessageEvent(UniversalBaseModel):
    """
    Represents an incoming message or message status update received via webhook.
    """

    type: WebhookEventEnum = pydantic.Field()
    """
    Type of webhook event. MESSAGE.STATUS for message status updates or MESSAGE.RECEIVED for inbound messages.
    """

    conversation: MessageEventConversation = pydantic.Field()
    """
    Conversation metadata containing the conversation ID, sender, and recipient information.
    """

    status: MessageStatusEnum
    direction: MessageEventDirection = pydantic.Field()
    """
    Direction of the message flow.
    """

    segments: int = pydantic.Field()
    """
    Number of segments for this message.
    """

    sent_at: typing_extensions.Annotated[str, FieldMetadata(alias="sentAt")] = pydantic.Field()
    """
    Timestamp when the message was sent in ISO 8601 format.
    """

    delivered_at: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="deliveredAt")] = (
        pydantic.Field(default=None)
    )
    """
    Timestamp when the message was delivered in ISO 8601 format.
    Null if not yet delivered or for inbound messages.
    """

    message: MessageEventContent

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
