# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class MessageEventConversation(UniversalBaseModel):
    """
    Conversation metadata containing the conversation ID, sender, and recipient information.
    """

    id: str = pydantic.Field()
    """
    Unique identifier for the conversation. This identifier is a string that always begins with the prefix `conv_`, for example: `conv_1234567890`. <br><br>
    To get more conversation details, use the [POST /conversations/get](/api-reference/conversations/get) endpoint.
    """

    from_: typing_extensions.Annotated[str, FieldMetadata(alias="from")] = pydantic.Field()
    """
    Sender's phone number or agent ID.
    """

    to: str = pydantic.Field()
    """
    Recipient's phone number.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
