# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class MessageEventMmsContent(UniversalBaseModel):
    """
    MMS message with text and/or media files from a phone number.
    """

    type: typing.Literal["MMS"] = pydantic.Field(default="MMS")
    """
    Message type identifier.
    """

    id: str = pydantic.Field()
    """
    Unique identifier of the message. This identifier is a string that always begins with the prefix `msg_`, for example: `msg_1234567890`. <br><br>
    To get the message details, use the [GET /messages/{id}](/api-reference/messages/get) endpoint.
    """

    media_urls: typing_extensions.Annotated[typing.List[str], FieldMetadata(alias="mediaUrls")] = pydantic.Field()
    """
    URLs of media files in this message. <br>
    
    See [supported media types](https://app.pinnacle.sh/supported-file-types?type=MMS).
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    Text content that may accompany the media files.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
