# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from .button_clicked_data import ButtonClickedData


class MessageEventRcsButtonData(ButtonClickedData):
    """
    Button click event data received when a user clicks on an RCS button or quick reply (excluding `requestUserLocation` buttons).

    This event contains information about which button was clicked, how many times it's been clicked, and any payload or metadata attached to the button. Use this data to handle user interactions with your RCS messages.
    """

    type: typing.Literal["RCS_BUTTON_DATA"] = pydantic.Field(default="RCS_BUTTON_DATA")
    """
    Message type identifier.
    """

    id: str = pydantic.Field()
    """
    Unique identifier of the message. This identifier is a string that always begins with the prefix `msg_`, for example: `msg_1234567890`. <br><br>
    To get the message details, use the [GET /messages/{id}](/api-reference/messages/get) endpoint.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
