# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from .location_share_action import LocationShareAction


class MessageEventRcsLocationData(LocationShareAction):
    """
    Location sharing event data received when a user responds to a `requestUserLocation` button and shares their current location.

    This event contains the geographic coordinates (latitude/longitude) and human-readable address of the location the user chose to share. Use this data to process location-based requests or provide location-specific services.
    """

    type: typing.Literal["RCS_LOCATION_DATA"] = pydantic.Field(default="RCS_LOCATION_DATA")
    """
    Message type identifier.
    """

    id: str = pydantic.Field()
    """
    Unique identifier of the message. This identifier is a string that always begins with the prefix `msg_`, for example: `msg_1234567890`. <br><br>
    To get the message details, use the [GET /messages/{id}](/api-reference/messages/get) endpoint.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
