# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .rich_button import RichButton


class MessageEventRcsMediaContent(UniversalBaseModel):
    """
    RCS message containing a media file with optional quick reply buttons. <br>

    See [supported file types](https://app.pinnacle.sh/supported-file-types?type=RCS-MEDIA).
    """

    type: typing.Literal["RCS_MEDIA"] = pydantic.Field(default="RCS_MEDIA")
    """
    Message type identifier.
    """

    id: str = pydantic.Field()
    """
    Unique identifier of the message. This identifier is a string that always begins with the prefix `msg_`, for example: `msg_1234567890`. <br><br>
    To get the message details, use the [GET /messages/{id}](/api-reference/messages/get) endpoint.
    """

    media: str = pydantic.Field()
    """
    URL of the media file.
    """

    quick_replies: typing_extensions.Annotated[typing.List[RichButton], FieldMetadata(alias="quickReplies")] = (
        pydantic.Field()
    )
    """
    List of interactive quick reply buttons in the message.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
