# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class MessageEventSmsContent(UniversalBaseModel):
    """
    SMS message containing plain text only.
    """

    type: typing.Literal["SMS"] = pydantic.Field(default="SMS")
    """
    Message type identifier.
    """

    id: str = pydantic.Field()
    """
    Unique identifier of the message. This identifier is a string that always begins with the prefix `msg_`, for example: `msg_1234567890`. <br><br>
    To get the message details, use the [GET /messages/{id}](/api-reference/messages/get) endpoint.
    """

    text: str = pydantic.Field()
    """
    Message content.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
