# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .message_with_reaction import MessageWithReaction


class MessageList(UniversalBaseModel):
    """
    Paginated list of messages in a conversation.
    """

    messages: typing.List[MessageWithReaction] = pydantic.Field()
    """
    Array of messages in the conversation.
    """

    has_more: typing_extensions.Annotated[bool, FieldMetadata(alias="hasMore")] = pydantic.Field()
    """
    Indicates if more messages are available beyond the current page.
    """

    count: int = pydantic.Field()
    """
    Total number of messages in the conversation.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
