# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class MessageSchedule(UniversalBaseModel):
    """
    Define when and how your message should be sent.
    """

    end_date: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="endDate")] = pydantic.Field(
        default=None
    )
    """
    Date and time when you want recurring messages to stop in ISO 8601 format.
    """

    recurrence: typing.Optional[str] = pydantic.Field(default=None)
    """
    Provide an AWS cron expression to control the when messages are sent. <br>
    
    [Learn more about cron expressions](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-scheduled-rule-pattern.html).
    """

    send_at: typing_extensions.Annotated[str, FieldMetadata(alias="sendAt")] = pydantic.Field()
    """
    Date and time when you want to send your message in ISO 8601 format.
    """

    timezone: str = pydantic.Field()
    """
    Timezone for your scheduled message, using an IANA identifier.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
