# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from .message import Message
from .message_with_reaction_direction import MessageWithReactionDirection


class MessageWithReaction(Message):
    """
    Message with additional conversation-specific fields including direction and reaction.
    """

    direction: MessageWithReactionDirection = pydantic.Field()
    """
    Direction of the message flow.
    """

    reaction: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unicode emoji reaction attached to this message. <br>
    
    Null indicates no reaction has been added.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
