# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class MmsContent(UniversalBaseModel):
    """
    Message with text and/or media files from a phone number.
    """

    media_urls: typing_extensions.Annotated[typing.List[str], FieldMetadata(alias="mediaUrls")] = pydantic.Field()
    """
    URLs of media files in this message. <br>
    
    See [supported media types](https://app.pinnacle.sh/supported-file-types?type=MMS).
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    Text content that accompanies the media files.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
