# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .mms_validation_response_segments_value_item import MmsValidationResponseSegmentsValueItem


class MmsValidationResponseSegments(UniversalBaseModel):
    """
    Details about how the MMS content would be segmented for delivery.
    """

    count: int = pydantic.Field()
    """
    Number of segments this message would be split into.
    """

    unsupported_files: typing_extensions.Annotated[typing.List[str], FieldMetadata(alias="unsupportedFiles")] = (
        pydantic.Field()
    )
    """
    List of unsupported media files included in the message. <br>
    
    This may be because the file is unreachable or not supported by the MMS protocol. See [supported file types](https://app.pinnacle.sh/supported-file-types?type=MMS).
    """

    value: typing.List[MmsValidationResponseSegmentsValueItem] = pydantic.Field()
    """
    Message segments with its content breakdown.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
