# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class NumberFormat(UniversalBaseModel):
    """
    Multiple formatting representations of the same phone number for different use cases.
    Provides flexibility for display, storage, and integration requirements.
    """

    international: str = pydantic.Field()
    """
    Phone number in E.164 format with country code prefix.
    """

    national: str = pydantic.Field()
    """
    Phone number formatted according to national conventions. <br>
    
    Includes parentheses, spaces, and dashes as commonly used in the country.
    """

    raw: str = pydantic.Field()
    """
    Phone number with only digits, no formatting or country code prefix.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
