# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .company_sector_enum import CompanySectorEnum
from .company_type_enum import CompanyTypeEnum
from .optional_contacts import OptionalContacts


class OptionalBrandInfo(UniversalBaseModel):
    address: typing.Optional[str] = pydantic.Field(default=None)
    """
    Primary brand address where this brand is located.
    """

    contact: typing.Optional[OptionalContacts] = None
    dba: typing.Optional[str] = pydantic.Field(default=None)
    """
    "Doing Business As" name - the public name this brand operates under.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Brief description of what this brand does.
    """

    ein: typing.Optional[str] = pydantic.Field(default=None)
    """
    Employer Identification Number (EIN) assigned by the IRS.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Main contact email address for this brand.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Legal name of the brand as registered.
    """

    sector: typing.Optional[CompanySectorEnum] = None
    type: typing.Optional[CompanyTypeEnum] = None
    website: typing.Optional[str] = pydantic.Field(default=None)
    """
    Brand website URL.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
