# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .phone_capabilities import PhoneCapabilities


class Phone(UniversalBaseModel):
    """
    Information about a phone number sender in a conversation.
    """

    capabilities: PhoneCapabilities
    created_at: typing_extensions.Annotated[str, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    ISO 8601 timestamp when the phone sender was created.
    """

    is_sandbox: typing_extensions.Annotated[bool, FieldMetadata(alias="isSandbox")] = pydantic.Field()
    """
    Whether this phone number is in sandbox/testing mode.
    """

    phone_number: typing_extensions.Annotated[str, FieldMetadata(alias="phoneNumber")] = pydantic.Field()
    """
    The sender's phone number in E.164 format.
    """

    updated_at: typing_extensions.Annotated[str, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    ISO 8601 timestamp when the phone sender was last updated
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
