# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class PhoneCapabilities(UniversalBaseModel):
    """
    Represents the communication capabilities available for a phone number.
    """

    mms: bool = pydantic.Field()
    """
    Whether the phone number supports MMS (multimedia messaging).
    """

    sms: bool = pydantic.Field()
    """
    Whether the phone number supports SMS messaging.
    """

    voice: bool = pydantic.Field()
    """
    Whether the phone number supports voice calls.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
