# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class PhoneNumberCost(UniversalBaseModel):
    """
    Pricing details for the phone number.
    """

    monthly: float = pydantic.Field()
    """
    Recurring monthly fee covering number ownership and basic services.
    """

    upfront: float = pydantic.Field()
    """
    One-time activation or setup fee charged at purchase.
    """

    currency: str = pydantic.Field()
    """
    Three-letter currency code for all pricing values.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
