# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .phone_enum import PhoneEnum
from .phone_feature_enum import PhoneFeatureEnum
from .phone_number_cost import PhoneNumberCost
from .phone_number_region import PhoneNumberRegion


class PhoneNumberDetails(UniversalBaseModel):
    """
    Details of a phone number available for purchase.
    Includes all essential data required for acquisition and operational planning.
    """

    number: str = pydantic.Field()
    """
    Phone number in E.164 format.
    """

    phone_type: PhoneEnum = pydantic.Field()
    """
    Classification that defines the number's billing model and geographic scope.
    """

    cost: PhoneNumberCost = pydantic.Field()
    """
    Pricing details for the phone number.
    """

    features: typing.List[PhoneFeatureEnum] = pydantic.Field()
    """
    Supported communication capabilities associated with the number.
    """

    region: PhoneNumberRegion = pydantic.Field()
    """
    Geographic and routing information for the phone number.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
