# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class PhoneNumberRegion(UniversalBaseModel):
    """
    Geographic and routing information for the phone number.
    """

    country: str = pydantic.Field()
    """
    Two-letter country code where the number is registered.
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    State or province code applicable to local numbers.
    """

    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    Primary city or metropolitan area served by the number.
    """

    rate_center: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="rateCenter")] = pydantic.Field(
        default=None
    )
    """
    Telecommunications rate center used for call routing and billing,
    defining local calling area boundaries.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
