# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .phone_number_status_enum import PhoneNumberStatusEnum


class PhoneNumberStatus(UniversalBaseModel):
    """
    Response for get phone number status.
    """

    errors: typing.List[str] = pydantic.Field()
    """
    List of errors that occured.
    """

    phone_number: typing_extensions.Annotated[str, FieldMetadata(alias="phoneNumber")] = pydantic.Field()
    """
    Phone number in E164 format that is in review
    """

    status: PhoneNumberStatusEnum = pydantic.Field()
    """
    Current status of the phone number. <br>
    
    `PENDING`: Not active during the one or more of the following: purchase pending, brand or campaign pending verification, and pending assignment to a campaign. To use a number, make sure to [attach it](../phone-numbers/attach-campaign) to an active campaign. <br>
    `ACTIVE`: Number is ready to send messages. <br>
    `FAILURE`: Errors occurred while activating this number. See the [errors field](phone-number#response.body.errors).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
